﻿/* Ver:		1.0
	
	DESC:		This loops over an area of tiles and calls a function for each.
					The area is defined by movieClip "bounds" data.
					Any tiles overlapping these bounds are be targeted.
	
	USAGE:	#include "functions/tileLoop.as"
					hitBlock = function( xTile, yTile ){
						BLOCKS[xTile][yTile].hit();
					}// hitBlock()
					var areaBounds = attack.getBounds( MAP );
					tileLoop( areaBounds, hitBlock );
*/
tileLoop = function( bounds, response_func )
{
	if(bounds.xMin!=undefined)
	{
//		var roundMethod = roundMethod || "floor";
		var tileSize = 16;
		var xTileMin = Math.floor(bounds.xMin/tileSize);
		var xTileMax = Math.floor(bounds.xMax/tileSize);
		var yTileMin = Math.floor(bounds.yMin/tileSize);
		var yTileMax = Math.floor(bounds.yMax/tileSize);
		for(var yy=yTileMin; yy<=yTileMax; yy++){
			for(var xx=xTileMin; xx<=xTileMax; xx++){
				response_func( xx, yy );
			}// for:  tileWidth
		}// for:  tileHeight
	}// if:  bounds
}// tileLoop()